#!/usr/bin/env python
# Add Checklist Item to Task
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041119 - first version of this script (based on OnInsertRow from GanttReport)
# 050831 - use cursor row if no rows are selected

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def DoInsertRow(self):
        if debug: print " Start DoInsertRow"

        if self.ReportID == 1:
            hint("Only for Task/Checklist Reports.")
            return

        # find the selected row
        rows = self.Report.table.rows  # translates screen row # to database row id
        if not rows:
            hint("There are no tasks to modify yet.")
            return

        sel = self.Report.GetSelectedRows()  # current selection
        if len(sel) == 1: 
            sel = sel[0]
        elif len(sel) > 1: 
            hint("May not be used if more than one row is selected.")
            return
        else:
            sel = self.Report.GetGridCursorRow()          
        rowid = rows[sel]  # get selection's task id

        # is this a task/checklist report
        r = Data.Report[self.ReportID]
        rt = Data.ReportType[r['ReportTypeID']]
        ta = rt['TableA']
        tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
        # each = rt.get('AllOrEach') in ['both', 'each']

        # is this a task or a checklist item
        tname = Data.ReportRow[rowid].get('TableName')
        tid = Data.ReportRow[rowid].get('TableID')
        if ta != 'Task' or tb != 'Checklist': 
            hint("Works only with Task or Checklist row")
            return  # only on task/checklist reports

        if tname == 'Task': # add a checklist item to task
            taskid = tid
        elif tname == 'Checklist':
            taskid = Data.Database[tname][tid].get('TaskID')
        else:
            taskid = None

        if not taskid:
            hint("Works only with Task or Checklist row")
            return

        change = { 'Table': tb, 'DateAdded': Data.GetToday(), 'TaskID': taskid }

        undo = Data.Update(change)  # created here to control where inserted

        Data.SetUndo('Insert Checklist Item')
        if debug: print "End DoInsertRow"

DoInsertRow(self)
